//
//  LSAnotoFile.h
//  LDMac
//
//  Created by Marcel Weiher on 10/3/08.
//  Copyright 2008 Livescribe. All rights reserved.
//

//#import <Foundation/Foundation.h>
#import "LSNonAnotoFile.h"

@class GridFile, StrokeList, LSImageList;

@interface LSAnotoFile : LSNonAnotoFile
{
	NSString	*filename;
	void		*documentHandle;
	BOOL		forWriting;
}


@property (nonatomic, retain) NSString* filename;

+ (LSAnotoFile *)loadAFDFromResourcesWithName:(NSString *)afdName;
- initWithPath:(NSString *)path 
	forWriting:(BOOL)writing;

+ (BOOL)convertSourcePath:(NSString *)sourceAFDPath 
		 toCurrentVersion:(NSString *)targetAFDPath;

- (UInt64)getPageAddress:(int)i
				 afdCopy:(int)copy;

- (void)copyStrokesFromPage:(int)pageNo 
			    document:(LSAnotoFile *)source 
			    forPenId:(long long)penId
				afdCopy:(int)copyNum
	withGridlessConversion:(GridFile *)gridFile;

- (void)copyStrokesFromPage:(int)pageNo 
			    document:(LSAnotoFile *)source 
			    forPenId:(long long)penId
				afdCopy:(int)copyNum;

- (void)copyStrokesFromPage:(int)pageNo 
				   document:(LSAnotoFile *)source 
				   forPenId:(long long)penId;

- (void)removeAllSessions;
- (void)removeAllStrokes;
- (void)removeAllGrids;
- (void)mergeChangesFrom:(LSAnotoFile *)sourceFile;

+ (NSPoint)convertPointToAFDCoordinateSystem:(NSPoint)location;
+ (NSString *)serializedPageAddress:(long long)address;
- (LSImageList *)imageListForPage:(int)pageNo;

- (NSArray *)directoryContentsAtPath:(NSString *)userPath;
- (NSData *)dataForUserDataAtPath:(NSString *)path;
- (NSData *)imageDataForName:(NSString *)name;

- (NSData *)iconImageDataForNotebook;
- (NSData *)iconImageDataForArchivedNotebook;
- (void)writeStandardPencastIcons;

- (NSString *)afdVersion;

- (int)numPages;
- (int)totalPages;
- (int)pageNumberOffset;

// Salil - Added for AFD copy support
- (int)numCopies;		
- (BOOL)getPageAndCopyFromPA:(UInt64)pageAddress 
						page:(long *)pageNumber 
						copy:(long *)copyNumber;

- (void)saveStrokes:(struct StrokeCollection *)strokes
			 atPage:(int)pageNo
		   forPenId:(long long)penId;

- (void)saveStrokes:(struct StrokeCollection *)strokes
			 atPage:(int)pageNo
		   forPenId:(long long)penId
			afdCopy:(int)copyNum;

// Salil - Added above for AFD copy support

- (UInt64)paLowerBounds;
- (UInt64)paUpperBounds;

+ (NSPoint)convertPointToAFDCoordinateSystem:(NSPoint)location;
+ (NSString*)penIdToSerial:(NSNumber *)penSN;

- (void)close;

- (void)deleteUserFile:(NSString *)userPath;

//--- reading and writing an upload AFD

- (void)writeGridFile:(NSData *)gridFileData 
			 withName:(NSString *)gridFileName;

- (void)writeGridFile:(NSData *)gridFileData 
	   forPageAddress:(long long)pageAddress;

- (void)writeAudioFile:(NSData *)content 
				  name:(NSString *)audioName  
		   sessionName:(NSString *)sessionName;

- (void)writeSessionInfoFile:(NSData *)content 
				 sessionName:(NSString *)sessionName;

- (void)writeSessionInfoXmlFile:(NSData *)content 
					sessionName:(NSString *)sessionName;

- (void)writeSessionPagesFile:(NSData *)content 
				  sessionName:(NSString *)sessionName;

- (int)generatePrintPSAtPath:(NSString *)targetPath;

- (void)writeUserData:(NSData *)content 
			   atPath:(NSString *)fullPath;

- (void)writeManifest:(NSData *)content;
- (void)writeMainInfo:(NSData *)content;
- (void)writeMainInfoDictionary:(NSDictionary *)dict;
- (NSDictionary *)interpretManifest;
- (NSDictionary *)interpretMainInfo;

- (NSArray *)sessions;

@end

//2011-0829 EEvL <DE4015>
@interface LSAnotoFile(customNotebook)

- (void) setupCustomNotebookForExport;
- (void) addNewPageWithNumber:(NSUInteger)pageNumber matchingPage:(Page *)srcPage;
- (void) addNewPagesWithRange:(NSRange)pageNumberRange matchingPages:(NSArray *)srcPages;
- (void) copyStrokesFromPage:(Page *)page forPenId:(long long)penId asPageNumber:(int)pageNumber;
- (void) copySession:(Session *)session forPages:(NSArray *)pages withGUID:(NSString *)newGUID;
- (void) finalizeCustomNotebookWithPages:(NSArray *)thePages title:(NSString *)notebookTitle guid:(NSString *)newGuid;
- (void) saveAndClose;

@end